﻿var panelistExport = {
    controller: "PanelistExportations",
    context: $(".v-exportPanelists"),
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        panelistExport.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-extractionTable", panelistExport.context).a4datatable({
            ajaxAction: a4.getAction("GetExportations", panelistExport.controller, "Panel"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id", "Type": "numeric" },
                { "Data": "Message", "Tooltip": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "v-name" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" },
                { "Name": "Type", "Title": resources.Type, "Data": "Type" },
                { "Name": "CreationDate", "Title": resources.CreationDate, "Data": "CreationDate", "Visible": false },
                { "Name": "LastRun", "Title": resources.LastRun, "Data": "LastRun", "type": "datetime", "DefaultValue": resources.NotAvailable },
                { "Name": "NextRun", "Title": resources.NextRun, "Data": "NextRun", "type": "datetime", "DefaultValue": resources.NotScheduled }
            ],
            defaultSorting: { Column: "CreationDate", Ascending: false },
            stateKey: "PanelistExportations",
            autoUpdate: true,
            toolBarItems: panelistExport.getToolBarItems(),
            contextMenuItems: panelistExport.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    panelistExport.deleteTasks(ids);
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var taskId = row.Id;
                var format = row.Type;

                switch (action) {
                    case "download":
                        panelistExport.downloadFile(taskId);
                        break;
                    case "executenow":
                        panelistExport.updateTaskStatus(taskId, 1);
                        break;
                    case "stop":
                        panelistExport.updateTaskStatus(taskId, 3);
                        break;
                    case "editSchedule":
                        modalDialog.showWindow(a4.getAction("ScheduleEditor", panelistExport.controller, "Panel", { taskId: taskId }), 600, 850,
                                                            { afterClose: function () { focusFirstField: false, panelistExport.refreshDataTable(); } });
                        break;
                    case "properties":
                        panelistExport.editTask(taskId, false, format);
                        break;
                    case "copy":
                        panelistExport.editTask(taskId, true, format);
                        break;
                    case "delete":
                        panelistExport.deleteTasks([taskId]);
                        break;
                    case "history":
                        modalDialog.showWindow(a4.getAction("TaskHistory", "Shared", "Home", { extractionId: taskId, name: row.Name }), 600, 950);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchExportPanelists }
        });
    },
    downloadFile: function (taskId) {
        window.location = a4.getAction("GetExportationFile", panelistExport.controller, "Panel", { taskId: taskId });
    },
    updateTaskStatus: function (taskId, status) {
        a4.callServerMethod(a4.getAction("UpdateExportationStatus", panelistExport.controller, "Panel"), { taskId: taskId, status: status },
        function (result) {
            panelistExport.refreshDataTable();
        });
    },
    deleteTasks: function (taskIds) {
        var itemsCount = taskIds.length || 1;

        modalDialog.showConfirmDelete(confirmDeleteTaskResources, function () {
            a4.callServerMethod(a4.getAction("DeleteExportations", panelistExport.controller, "Panel"), { taskIds: taskIds },
                function (result) {
                    panelistExport.refreshDataTable();
                });
        },  itemsCount);
    },
    editTask: function (taskId, copyTask, exportFormat) {
        var params = {
            id: taskId || null,
            copyTask: copyTask || false,
            exportFormat: exportFormat
        };
        window.location = a4.getAction("ExportPanelistWizard", panelistExport.controller, "Panel", params);
    },
    getContextMenuItems: function () {
        var isNotRunning = function (data) { return data.Status != "Running"; };
        var menuItems = [
            { "Action": "editSchedule", "Label": resources.EditSchedule, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": isNotRunning },
            { "Action": "properties", "Label": resources.Properties, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return _.contains(["Running", "Pending"], data.Status); } },
            { "Action": "executenow", "Label": resources.ExecuteNow, "DisplayCondition": isNotRunning },
            { "Action": "history", "Label": resources.History }
        ];

        if (hasPIIReadPermission) {
            menuItems.push({ "Divider": true });
            menuItems.push({
                "Action": "download", "Label": resources.DownloadFile,
                "DisplayCondition": function (data) { return  _.contains(["Completed", "Stopped", "Pending"], data.Status); }
            });
        }
        return menuItems;
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    },
    bindEvents: function () {
        this.context.on("click", ".h-addTask", function () {
            panelistExport.editTask();
        });
    }
}

$(document).ready(function () {
    if (panelistExport.context.length > 0) {
        panelistExport.initializeDataTable();
        panelistExport.bindEvents();
    }

    $(".exportation-section-header").on("click", function () {
        var currentSection = $(this).parent();
        currentSection.find(".exportation-subsection-title .fa").toggleClass("fa-caret-up");
        currentSection.find(".exportation-section-content").toggleClass('hideItem')
    });
});